/**
 * Created by lei.wang_1 on 2016/11/18.
 */
appModule.directive("bar", [function () {
    return {
        template:`<span class="bars">
                    <span ng-repeat="rect in data" class="bar {{rect.class}}" ng-style="rect.style"></span> 
                    <span ng-bind="message" class="message bar" ng-click="onMessageClick()" ng-class="{'hyper-link':enableClick}" ng-style="messageStyle"></span>
                 </span>`,
        restrict: "E",
        replace:true,
        scope: {
            data: "=",
            message:"=",
            onMessageClick:"&",
            enableClick:"="
        },
        link: function ($scope) {
            var stopWatch = $scope.$watch("data", function (newV) {
                if(newV){
                    $scope.messageLeft = 0;
                    $scope.data.forEach(function(item){
                        var width = parseFloat(item.width);
                        $scope.messageLeft = Math.max($scope.messageLeft,width);
                        item.style={
                            width: item.width,
                            'z-index':item.index || 0
                        };
                        $scope.messageStyle={
                            left:$scope.messageLeft + '%'
                        };
                    });
                    if($scope.messageLeft == 0){
                        $scope.messageStyle['padding-left'] = 0;
                    }
                }
            });

            $scope.$on("$destroy", function () {
                stopWatch();
            });
        }
    };
}]);